-- View: gepland_view

-- DROP VIEW gepland_view;

CREATE OR REPLACE VIEW gepland_view AS 
 SELECT p.bouwplanid AS id, p.periodeid, p.periodeomschrijving AS omschrijving, sum(
        CASE
            WHEN p.factsoortid <> 1 AND p.factsoortid <> 2 AND p.factsoortid <> 19 AND p.factsoortid <> 27 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_t, COALESCE(max(
        CASE
            WHEN p.factsoortid = 3 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 4 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 34 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_s3, COALESCE(COALESCE(max(
        CASE
            WHEN p.factsoortid = 37 THEN p.planningaantal
            ELSE NULL::integer
        END), 0), 0) AS p_h_eg_s4, COALESCE(max(
        CASE
            WHEN p.factsoortid = 5 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 31 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 21 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 6 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 7 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 35 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_s3, COALESCE(max(
        CASE
            WHEN p.factsoortid = 38 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_s4, COALESCE(max(
        CASE
            WHEN p.factsoortid = 8 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 32 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 22 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 9 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 10 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 36 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_s3, COALESCE(max(
        CASE
            WHEN p.factsoortid = 39 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_s4, COALESCE(max(
        CASE
            WHEN p.factsoortid = 11 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 33 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 23 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 12 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_eg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 13 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_eg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 28 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_eg_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 24 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_eg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 14 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_mg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 15 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_mg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 29 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_mg_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 25 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_mg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 16 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_on_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 17 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_on_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 30 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_on_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 26 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_on_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 40 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_o_eg, COALESCE(max(
        CASE
            WHEN p.factsoortid = 41 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_o_mg, COALESCE(max(
        CASE
            WHEN p.factsoortid = 18 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_o_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 2 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_s, COALESCE (max(
        CASE 
		WHEN p.factsoortid = 27 THEN p.planningaantal
		ELSE NULL::integer
	END),0) as gerealiseerd
   FROM planningaantal_per_soort_per_periode_per_bouwplan p
  GROUP BY p.bouwplanid, p.periodeomschrijving, p.periodeid
  ORDER BY p.bouwplanid, p.periodeomschrijving;

ALTER TABLE gepland_view OWNER TO planmonitor;

